<?php
namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Stdlib\CookieManagerInterface;

class UserUpdateObserver implements ObserverInterface
{
    /**
     * Description message.
     *
     * @var LoggerInterface $logger
     */
    
     protected $_logger;

    /**
     * Description message.
     *
     * @var Curl $curl
     */
    
     protected $_curl;

    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */
    
     protected $_scopeConfig;

    /**
     * Description message.
     *
     * @param LoggerInterface $logger
     * @param ScopeConfigInterface $scopeConfig
     * @param Curl $curl
     */
    public function __construct(
        LoggerInterface $logger,
        ScopeConfigInterface $scopeConfig,
        Curl $curl
    ) {
        $this->_logger = $logger;
        $this->_curl = $curl;
        $this->_scopeConfig = $scopeConfig;
    }

    /**
     * Description message.
     *
     * @param Observer $observer
     *
     * @return Observer $observer
     */
    public function execute(Observer $observer)
    {

        $customerAddress = $observer->getCustomerAddress();
        $customer = $customerAddress->getCustomer();
        $customerAddressData = $customerAddress->getData();

        $email = $customer->getEmail();
        $phone = $customerAddressData['telephone'];

        $firstName = $customer->getFirstname();
        $lastName = $customer->getLastname();
        $fullName = $firstName . ' ' . $lastName;

        $eventData = [];
        
        if (isset($email) && !empty($email)) {
            $eventData['email'] = (string) $email;
        }

        if (isset($phone) && !empty($phone)) {
            $eventData['phone'] = $phone;
        }

        if (isset($firstName) && !empty($firstName)) {
            $eventData['name'] = $fullName;
        }

        $cookieManager = ObjectManager::getInstance()->get(CookieManagerInterface::class);

        $parleg_cookie = $cookieManager->getCookie('parleg');
        if ($parleg_cookie) {
            $parleg_data = json_decode($parleg_cookie, true);
            $nitro_id = $parleg_data['id'];
            $biscuit_id = $parleg_data['biscuit'];
        } else {
            $this->_logger->error('parleg cookie not found');
            return $this;
        }

        $orgToken = $this->_scopeConfig->getValue('admin/nitrox/nitrox_org_token', ScopeInterface::SCOPE_STORE);

        $userAuthData = [
            'nitro_id' => $nitro_id,
            'roaming_id' => $biscuit_id,
            'org_token' => $orgToken
        ];

        try {
            $body = base64_encode(json_encode($eventData));
            
            $orgToken = $userAuthData['org_token'];
            $roaming_id = $userAuthData['roaming_id'];
            $nitro_id = $userAuthData['nitro_id'];

            $url = "https://t.makehook.ws/jsv1/identify/$orgToken/$roaming_id/$nitro_id/$body";
            $headers = ['Content-Type' => 'application/json'];
            $this->_curl->setHeaders($headers);
            $this->_curl->get($url);
            $response = $this->_curl->getBody();

            if ($this->_curl->getStatus() != 200) {
                // throw new \Exception("API returned HTTP status code " . $this->_curl->getStatus());
                $this->_logger->error("User Update API returned HTTP status code " . $this->_curl->getStatus());
            }

            $this->_logger->info("User Update Page View API Response: " . $response);

        } catch (\Exception $e) {
            $this->_logger->error("User Update Page View API Error: " . $e->getMessage());
        }

        return $this;
    }
}
