<?php

namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Stdlib\CookieManagerInterface;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Framework\App\Config\ScopeConfigInterface;

class UserRegisterObserver implements ObserverInterface
{
    /**
     * Description message
     *
     * @var LoggerInterface $logger
     */
    
     protected $_logger;

    /**
     * Description message
     *
     * @var CustomerRepositoryInterface $customerRepository
     */
    
     protected $_customerRepository;

     /**
     * Description message.
     *
     * @var Curl $curl
     */
    
     protected $_curl;

    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */
    
     protected $_scopeConfig;

    /**
     * Description message
     *
     * @param LoggerInterface $logger
     * @param CustomerRepositoryInterface $customerRepository
     * @param Curl $curl
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        LoggerInterface $logger,
        CustomerRepositoryInterface $customerRepository,
        Curl $curl,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->_logger = $logger;
        $this->_customerRepository = $customerRepository;
        $this->_curl = $curl;
        $this->_scopeConfig = $scopeConfig;
    }

    /**
     * Description message
     *
     * @param Observer $observer
     *
     * @return Observer $observer
     */
    public function execute(Observer $observer)
    {
        $customer = $observer->getEvent()->getCustomer();
        $customerData = $this->_customerRepository->getById($customer->getId());
        
        $email = $customerData->getEmail();
        
        $phoneData = $customerData->getCustomAttribute('phone');
        $phone = null;
        
        if (null !== $phoneData) {
            $phone = $phoneData->getValue();
        }

        $firstName = $customerData->getFirstname();
        $lastName = $customerData->getLastname();
        $fullName = $firstName . ' ' . $lastName;

        $eventData = [];
        
        if (isset($email) && !empty($email)) {
            $eventData['email'] = (string) $email;
        }

        if (isset($phone) && !empty($phone)) {
            $eventData['phone'] = $phone;
        }

        if (isset($firstName) && !empty($firstName)) {
            $eventData['name'] = $fullName;
        }

        $cookieManager = ObjectManager::getInstance()->get(CookieManagerInterface::class);

        $parleg_cookie = $cookieManager->getCookie('parleg');
        if ($parleg_cookie) {
            $parleg_data = json_decode($parleg_cookie, true);
            $nitro_id = $parleg_data['id'];
            $biscuit_id = $parleg_data['biscuit'];
        } else {
            $this->_logger->error('parleg cookie not found');
            return $this;
        }

        $orgToken = $this->_scopeConfig->getValue('admin/nitrox/nitrox_org_token', ScopeInterface::SCOPE_STORE);

        $userAuthData = [
            'nitro_id' => $nitro_id,
            'roaming_id' => $biscuit_id,
            'org_token' => $orgToken
        ];

        try {
            $body = base64_encode(json_encode($eventData));
            
            $orgToken = $userAuthData['org_token'];
            $roaming_id = $userAuthData['roaming_id'];
            $nitro_id = $userAuthData['nitro_id'];

            $url = "https://t.makehook.ws/jsv1/identify/$orgToken/$roaming_id/$nitro_id/$body";
            $headers = ['Content-Type' => 'application/json'];
            $this->_curl->setHeaders($headers);
            $this->_curl->get($url);
            $response = $this->_curl->getBody();

            if ($this->_curl->getStatus() != 200) {
                // throw new \Exception("API returned HTTP status code " . $this->_curl->getStatus());
                $this->_logger->error("User Register API returned HTTP status code " . $this->_curl->getStatus());
            }

            $this->_logger->info("User Register Page View API Response: " . $response);

        } catch (\Exception $e) {
            $this->_logger->error("User Register Page View API Error: " . $e->getMessage());
        }

        return $this;
    }
}
