<?php

namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\LayoutInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Session\SessionManager;
use Magento\Framework\Stdlib\CookieManagerInterface;

class RemoveFromCartObserver implements ObserverInterface
{
    /**
     * Description message.
     *
     * @var LoggerInterface $logger
     */

    protected $_logger;
    
    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */
    
     protected $_scopeConfig;
    
     /**
      * Description message.
      *
      * @var Curl $curl
      */
    
     protected $_curl;
    
     /**
      * Description message.
      *
      * @var LayoutInterface $layout
      */
    
     protected $layout;
    
     /**
      * Description message.
      * @var ObjectManagerInterface $objectManager
      */
    
     protected $scopeInterface;

     /**
      * Description message.
      * @var SessionManager $sessionManager
      */
    
     protected $sessionManager;

    /**
     * Description message.
     *
     * @param LoggerInterface $logger
     * @param ObjectManagerInterface $objectManager
     * @param LayoutInterface $layout
     * @param ScopeConfigInterface $scopeConfig
     * @param Curl $curl
     * @param SessionManager $sessionManager
     */
    public function __construct(
        LoggerInterface $logger,
        ObjectManagerInterface $objectManager,
        LayoutInterface $layout,
        ScopeConfigInterface $scopeConfig,
        Curl $curl,
        SessionManager $sessionManager
    ) {
        $this->_logger = $logger;
        $this->layout = $layout;
        $this->scopeInterface = $objectManager::getInstance()->create(ScopeConfigInterface::class);
        $this->_scopeConfig = $scopeConfig;
        $this->_curl = $curl;
        $this->sessionManager = $sessionManager;
    }

    /**
     * Description message.
     *
     * @param mixed $event
     * @param mixed $NitroxData
     * @param mixed $data
     *
     * @return void
     */
    private function postEvent($event, $NitroxData, $data)
    {
        try {
            // $body = base64_encode(json_encode($data));
            $body = json_encode($data);
            
            $orgToken = $NitroxData['org_token'];
            $roaming_id = $NitroxData['roaming_id'];
            $nitro_id = $NitroxData['nitro_id'];
            
            $url = "https://t.makehook.ws/jsv1/$orgToken/$roaming_id/$nitro_id/null/event/$event";
            $this->_logger->debug('Nitrox Start RemoveFromCart $url: ' . $url);
            $headers = ['Content-Type' => 'application/json'];
            $this->_curl->setHeaders($headers);
            // $this->_curl->get($url);
            $this->_curl->post($url, $body);
            $response = $this->_curl->getBody();

            if ($this->_curl->getStatus() != 200) {
                // throw new \Exception("API returned HTTP status code " . $this->_curl->getStatus());
                $this->_logger->error($event . " API returned HTTP status code " . $this->_curl->getStatus());
            }

            $this->_logger->info($event . " Page View API Response: " . $response);

        } catch (\Exception $e) {
            $this->_logger->error($event . " Page View API Error: " . $e->getMessage());
        }
    }

    /**
     * Description message.
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $this->_logger->debug('Nitrox Start RemoveFromCart Debug');

        $eventName = $observer->getEvent()->getName();
        
        $this->_logger->debug("Event Name: " . $eventName);

        $objectManager = ObjectManager::getInstance();
        $checkoutSession = $objectManager->get(\Magento\Checkout\Model\Session::class);

        $quote = $checkoutSession->getQuote();
        $storeManager = $objectManager->get(\Magento\Store\Model\StoreManagerInterface::class);
        $store = $storeManager->getStore();

        $imagePrefixUrl = $store->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . 'catalog/product';

        $line_items = [];
        $totalCartValue = 0;
        foreach ($quote->getAllVisibleItems() as $item) {
            $product = $item->getProduct();
            $line_items[] = [
                'quantity' => $item->getQty(),
                'title' => $product->getName(),
                'line_price' => $product->getFinalPrice(),
                'id' => $item->getId(),
                'product_id' => $product->getId(),
                'image_url' => $imagePrefixUrl . $product->getImage()
            ];
        }
        
        $quote->collectTotals()->save();

        $cart_data = [
            'line_items' => $line_items,
            'cart_value' => $quote->getGrandTotal()
        ];

        $eventData = $cart_data;

        $cookieManager = ObjectManager::getInstance()->get(CookieManagerInterface::class);

        $parleg_cookie = $cookieManager->getCookie('parleg');
        if ($parleg_cookie) {
            $parleg_data = json_decode($parleg_cookie, true);
            $nitro_id = $parleg_data['id'];
            $biscuit_id = $parleg_data['biscuit'];
        } else {
            $this->_logger->error('parleg cookie not found');
            return $this;
        }

        $orgToken = $this->_scopeConfig->getValue('admin/nitrox/nitrox_org_token', ScopeInterface::SCOPE_STORE);

        $userAuthData = [
            'nitro_id' => $nitro_id,
            'roaming_id' => $biscuit_id,
            'org_token' => $orgToken
        ];
        
        $this->_logger->debug('Nitrox End update Debug' . print_r($eventData, true));

        $this->postEvent('updatecart', $userAuthData, $eventData);

        $this->_logger->debug('Nitrox End RemoveFromCart Debug');

        return $this;
    }
}