<?php

namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\LayoutInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Framework\Event\Observer;
use Magento\Framework\App\ObjectManager;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\Stdlib\CookieManagerInterface;

class ProductViewObserver implements ObserverInterface
{
    /**
     * Description message.
     *
     * @var LoggerInterface $logger
     */
    
     protected $_logger;

    /**
     * Description message.
     *
     * @param LoggerInterface $logger
     */
    public function __construct(
        LoggerInterface $logger
    ) {
        $this->_logger = $logger;
    }

    /**
     * Description message.
     *
     * @param Observer $observer
     *
     * @return Observer $observer
     */
    public function execute(Observer $observer)
    {
        $this->_logger->debug('Nitrox Start ProductViewObserver Debug');
        $product = $observer->getEvent()->getProduct();
        
        $canonicalUrl = $product->getProductUrl();
        $price = (string) $product->getFinalPrice();
        $productId = (string) $product->getId();

        $product_data = [
            'product_id' => $productId,
            'price' => $price,
            'product_url' => $canonicalUrl
        ];
        
        $this->_logger->debug('Product View Page:- ' . print_r($product_data, true));

        echo "<script data-cfasync='false' type='text/javascript'>
            document.addEventListener('DOMContentLoaded', function() {
                if (window.nitro) {
                    setTimeout(function(){
                        nitro.productView(" . json_encode($product_data) . ");
                    }, 1500);
                }
            });
        </script>";

        $this->_logger->debug('Nitrox End ProductViewObserver Debug');

        return $this;
    }
}
