<?php

namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\ObserverInterface;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\Result\RawFactory;
use Psr\Log\LoggerInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Catalog\Model\CategoryFactory;
use Magento\Framework\App\Response\Http;
use Magento\Framework\HTTP\Client\Curl;
use Magento\Framework\Event\Observer;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Stdlib\CookieManagerInterface;

class PageViewObserver implements ObserverInterface
{
    /**
     * Description message.
     *
     * @var LoggerInterface $logger
     */
    
     protected $_logger;

    /**
     * Description message.
     *
     * @var UrlInterface $urlInterface
     */
    
     protected $urlInterface;

    /**
     * Description message.
     *
     * @var RequestInterface $requestInterface
     */
    
     protected $requestInterface;

    /**
     * Description message.
     *
     * @var CategoryFactory $categoryFactory
     */
    
     protected $categoryFactory;

    /**
     * Description message.
     *
     * @var Http $response
     */
    
     protected $response;

    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */
    
     protected $_scopeConfig;

    /**
     * Description message.
     *
     * @var Curl $curl
     */
    
     protected $_curl;

    /**
     * Description message.
     *
     * @var RawFactory $resultRawFactory
     */
    
     protected $resultRawFactory;

    /**
     * Description message.
     *
     * @var JsonFactory $resultJsonFactory
     */
    
     protected $resultJsonFactory;

    /**
     * Description message.
     *
     * @param LoggerInterface $logger
     * @param UrlInterface $urlInterface
     * @param RequestInterface $requestInterface
     * @param CategoryFactory $categoryFactory
     * @param Http $response
     * @param ScopeConfigInterface $scopeConfig
     * @param Curl $curl
     * @param JsonFactory $resultJsonFactory
     * @param RawFactory $resultRawFactory
     */
    public function __construct(
        LoggerInterface $logger,
        UrlInterface $urlInterface,
        RequestInterface $requestInterface,
        CategoryFactory $categoryFactory,
        Http $response,
        ScopeConfigInterface $scopeConfig,
        Curl $curl,
        JsonFactory $resultJsonFactory,
        RawFactory $resultRawFactory
    ) {
        $this->_logger = $logger;
        $this->urlInterface = $urlInterface;
        $this->requestInterface = $requestInterface;
        $this->categoryFactory = $categoryFactory;
        $this->response = $response;
        $this->_scopeConfig = $scopeConfig;
        $this->_curl = $curl;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->resultRawFactory = $resultRawFactory;
    }

    /**
     * Description message.
     *
     * @param RequestInterface $request
     *
     * @return string
     */
    private function getFullUrl(RequestInterface $request)
    {
        return $request->getScheme() . '://' . $request->getHttpHost() . $request->getRequestUri();
    }

    /**
     * Description message.
     *
     * @param RequestInterface $request
     *
     * @return ($currentController is 'category' ? string : null
     */
    private function getCategoryDetails(RequestInterface $request)
    {
        $currentController = $request->getControllerName();
        $currentAction = $request->getActionName();
        $currentRoute = $request->getRouteName();

        if ($currentRoute === 'catalog' && $currentController === 'category' && $currentAction === 'view') {
            $categoryId = (int) $request->getParam('id');
            $category = $this->categoryFactory->create()->load($categoryId);

            return [
                'url' => $category->getUrl(),
                'name' => $category->getName()
            ];
        }

        return null;
    }

    /**
     * Description message.
     *
     * @param Observer $observer
     *
     * @return Observer $observer
     */
    public function execute(Observer $observer)
    {
        $this->_logger->debug('Nitrox Start PageViewObserver Debug');
        
        $request = $observer->getEvent()->getRequest();
        
        $current_url = $this->getFullUrl($request);
        
        // $fullActionName = $this->requestInterface->getFullActionName();
        $fullActionName = $request->getFullActionName();
        $this->_logger->debug('Current action name:- ' . print_r($fullActionName, true));
        $categoryDetail = $this->getCategoryDetails($request);
        
        if (null !== $categoryDetail) {
            $this->_logger->debug('Category Page:- ' . print_r($categoryDetail, true));
            $eventData = [
                'category' => $categoryDetail['name'],
            ];
            echo "<script data-cfasync='false' type='text/javascript'>
                document.addEventListener('DOMContentLoaded', function() {
                    if (window.nitro) {
                        setTimeout(function(){
                            nitro.categoryView(" . json_encode($eventData) . ");
                        }, 1500);
                    }
                });
            </script>";

            // $this->postEvent('categoryview', $userAuthData, $eventData);
        }
        
        if ('checkout_index_index' == $fullActionName) {
            $checkout_url = $this->urlInterface->getUrl('checkout');

            $this->_logger->debug('Checkout Page:- ' . print_r($checkout_url, true));
            
            $objectManager = ObjectManager::getInstance();
            $checkoutSession = $objectManager->get(\Magento\Checkout\Model\Session::class);

            $quote = $checkoutSession->getQuote();

            $eventData = [
                'checkout_url' => $this->urlInterface->getUrl('checkout/cart'),
                'total_price' => $quote->getGrandTotal()
            ];

            echo "<script data-cfasync='false' type='text/javascript'>
                document.addEventListener('DOMContentLoaded', function() {
                    if (window.nitro) {
                        setTimeout(function(){
                            nitro.checkout(" . json_encode($eventData) . ");
                        }, 1500);
                    }
                });
            </script>";

            $this->_logger->debug('Checkout page:- ' . print_r($eventData, true));
            
            // $this->postEvent('checkoutstarted', $userAuthData, $eventData);
        }

        // $this->_logger->debug('Current Page messages:- ' . print_r($messages, true));
        $this->_logger->debug('Current Page:- ' . $current_url);
        $this->_logger->debug('Nitrox End PageViewObserver Debug');

        return $this;
    }
}
