<?php

namespace Nitrox\EventBridge\Observer;

use Magento\Framework\Event\ObserverInterface;
use Psr\Log\LoggerInterface;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Stdlib\CookieManagerInterface;
use Magento\Sales\Model\Order;


class BuyObserver implements ObserverInterface
{
    /**
     * Description message.
     *
     * @var LoggerInterface $logger
     */
    
     protected $_logger;

    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */
    
     protected $_scopeConfig;

    /**
     * Description message.
     *
     * @var Session $checkoutSession
     */
    
     protected $checkoutSession;

    /**
     * Description message.
     *
     * @var RequestInterface $request
     */
    
     protected $request;

    /**
     * Description message.
     *
     * @param LoggerInterface $logger
     * @param Session $checkoutSession
     * @param RequestInterface $request
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        LoggerInterface $logger,
        Session $checkoutSession,
        RequestInterface $request,
        ScopeConfigInterface $scopeConfig,
    ) {
        $this->_logger = $logger;
        $this->checkoutSession = $checkoutSession;
        $this->request = $request;
        $this->_scopeConfig = $scopeConfig;
    }

    /**
     * Description message.
     *
     * @param object $order
     *
     * @return (product count is greater than 0) ? array : null
     */
    private function getProducts($order)
    {
        $items = $order->getAllVisibleItems();

        $products = [];
        foreach ($items as $item) {
            $products[] = [
                'price' => $item->getRowTotal(),
                'product_id' => $item->getId(),
                'product_url' => $item->getProductUrl()
            ];
        }

        return count($products) > 0 ? $products : null;
    }

    /**
     * Description message.
     *
     * @param Observer $observer
     *
     * @return Observer $observer
     */
    public function execute(Observer $observer)
    {
        $this->_logger->debug('Nitrox Start BuyObserver Debug');

        // $order = $observer->getEvent()->getOrder();
        
        $getOrderId = $observer->getEvent()->getOrderIds();
        
        if (!isset($getOrderId)) {
            return;
        }

        $orderIdForOrderDetails = $getOrderId[0];
        $order = ObjectManager::getInstance()->create(Order::class)->load($orderIdForOrderDetails);
        $objectManager = ObjectManager::getInstance();
        $urlBuilder = $objectManager->get(\Magento\Framework\UrlInterface::class);

        $orderStatusUrl = $urlBuilder->getUrl('checkout/onepage/success');
        $totalPrice = $order->getGrandTotal();
        $currency = $order->getOrderCurrencyCode();

        $eventData = [
            'order_status_url' => $orderStatusUrl,
            'order_id' => $orderIdForOrderDetails,
            'total_price' => $totalPrice,
            'currency' => $currency
        ];

        $this->_logger->debug('BuyObserver EvetnData:- ' . print_r($eventData, true));

        if (null !== $orderIdForOrderDetails) {
            echo "<script data-cfasync='false' type='text/javascript'>
                document.addEventListener('DOMContentLoaded', function() {
                    if (window.nitro) {
                        console.log('buy Observer data:- ', ".json_encode($eventData).");
                        setTimeout(function(){
                            nitro.buy(" . json_encode($eventData) . ");
                        }, 1500);
                    }
                });
            </script>";
        }

        $this->_logger->debug('Nitrox End BuyObserver Debug');

        return $this;
    }
}
