<?php
namespace Nitrox\EventBridge\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Module\ModuleListInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Helper\AbstractHelper;

class Data extends AbstractHelper {
    
    protected $config;
    protected $store;
    protected $context;
    protected $storeManager;
    protected $scopeConfig;
    protected $logger;
    protected $moduleList;
    protected $codeDirectory;
    
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        ModuleListInterface $moduleList,
        DirectoryList $directoryList
    ) {
        parent::__construct($context);
        $this->context = $context;
        $this->storeManager = $storeManager;
        $this->scopeConfig = $context->getScopeConfig();
        $this->logger = $context->getLogger();
        $this->moduleList = $moduleList;
        $this->codeDirectory = $directoryList->getPath(DirectoryList::APP);
    }

    public function getVersion() {
        return $this->moduleList->getOne($this->getModuleName())['setup_version'];
    }

    public function getModuleName() {
        return $this->_getModuleName();
    }

    public function getBaseDir() {
        return $this->codeDirectory  . '/code/Nitrox/';
    }

    public function formatDate($str) {
        if($str) {
            if(false !== stripos($str, ' ')) {
                $str = substr($str, 0, stripos($str, ' '));
            }
        }

        return $str;
    }

    public function toArray($value, $create = false) {
        if($value !== false) {
            return is_array($value) ? $value : array($value);
        } else {
            return $create ? array() : $value;
        }
    }

    public function logException($ex, $msg) {
        $this->logger->debug($ex);
        return false;
    }

    public function log($msg) {
        return $this->logger->info($msg);
    }

    public function getStore() {
        if($this->store == null) {
            $this->store = $this->storeManager->getStore();
        }

        return $this->store;
    }

    public function getStores() {
        return $this->storeManager->getStores();
    }

    public function paginate($array, $pageNumber, $pageSize) {
        $start = $pageNumber * $pageSize;
        return array_slice($array, $start, $pageSize);
    }

    public function throwExceptionWithBacktraceToAPIResponse($response, $error) {
        $errorMessage = $error->getMessage();
        $backtrace = $error->getTraceAsString();
        
        $response->setHttpResponseCode(500);
        $response->setHeader('Content-Type', 'application/json', true);
        $response->setBody(json_encode([
            'error' => $errorMessage, 
            'backtrace' => $backtrace
        ]));
        
        return $response->sendResponse();
    }

    public function sendResponseToClient($response, $data) {
        
        $response->setHttpResponseCode(200);
        $response->setHeader('Content-Type', 'application/json', true);
        $response->setBody(json_encode($data));
        
        return $response->sendResponse();
    }

    public function sendAuthenticationErrorToClient($response) {
        // Set HTTP response code to 401 Unauthorized
        $message = [
                    'status' => "Unauthorized",
                    'message' => 'Please verify the access token'
                ];
        $response->setHttpResponseCode(401);
        $response->setHeader('Content-Type', 'application/json', true);
        $response->setBody(json_encode($message));
        return $response->sendResponse();
    }
}