<?php
namespace Nitrox\EventBridge\Controller\Login;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Message\ManagerInterface as MessageManagerInterface;
use Magento\Customer\Model\Session as CustomerSession;
use Nitrox\EventBridge\Model\Nitro;
use Magento\Customer\Model\CustomerFactory;
use Magento\Framework\Controller\ResultInterface;
use Psr\Log\LoggerInterface;

class Auth implements HttpGetActionInterface
{
    private $request;
    private $redirectFactory;
    private $messageManager;
    private $customerSession;
    private $nitroService;
    private $logger;
    private $customerFactory;

    public function __construct(
        RequestInterface $request,
        RedirectFactory $redirectFactory,
        MessageManagerInterface $messageManager,
        CustomerSession $customerSession,
        CustomerFactory $customerFactory,
        Nitro $nitroService,
        LoggerInterface $logger
    ) {
        $this->request = $request;
        $this->redirectFactory = $redirectFactory;
        $this->messageManager = $messageManager;
        $this->customerSession = $customerSession;
        $this->customerFactory = $customerFactory;
        $this->nitroService = $nitroService;
        $this->logger = $logger;
    }

    public function execute(): ResultInterface
    {
        $token = $this->request->getParam('token');

        if (!$token) {
            $this->messageManager->addErrorMessage(__('SSO authentication failed: Missing token.'));
            return $this->redirectToHomepage();
        }

        $userData = $this->nitroService->validateToken($token);
        if (!$userData || empty($userData['email'])) {
            $this->messageManager->addErrorMessage(__('SSO authentication failed: Invalid token.'));
            return $this->redirectToHomepage();
        }

        $customerData = $this->nitroService->getCustomerByEmail($userData['email']);
        if (!$customerData) {
            $this->messageManager->addErrorMessage(__('Customer not found.'));
            return $this->redirectToHomepage();
        }

        // Convert CustomerInterface to Customer Model
        $customer = $this->customerFactory->create()->load($customerData->getId());

        $this->customerSession->setCustomerAsLoggedIn($customer);
        $this->messageManager->addSuccessMessage(__('Welcome %1! You have been successfully logged in via SSO.', $customer->getFirstname()));

        return $this->redirectToCustomerAccount();
    }

    private function redirectToHomepage(): ResultInterface
    {
        return $this->redirectFactory->create()->setPath('');
    }

    private function redirectToCustomerAccount(): ResultInterface
    {
        return $this->redirectFactory->create()->setPath('customer/account');
    }
}
