<?php
namespace Nitrox\EventBridge\Controller\Adminhtml\Config;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Config\Model\ResourceModel\Config;
use Psr\Log\LoggerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Magento\Framework\Filesystem\Driver\File as FileDriver;
use Magento\Framework\App\Cache\Manager as CacheManager;
use Magento\Framework\App\Cache\TypeListInterface as CacheTypeList;
use Magento\Store\Model\ScopeInterface;

class Index extends Action
{
    /**
     * Description message.
     * @var PageFactory $resultPageFactory
     */

    protected $resultPageFactory;

    /**
     * Description message.
     * @var Config $_resourceConfig
     */

    protected $_resourceConfig;

    /**
     * Description message.
     * @var LoggerInterface $logger
     */

    protected $logger;

    /**
     * Description message.
     * @var Manager $cacheManager
     */

    protected $cacheManager;

    /**
     * Description message.
     * @var TypeListInterface $cacheTypeList
     */

    protected $cacheTypeList;

    /**
     * Description message.
     * @var ScopeConfigInterface $scopeConfig
     */

    protected $scopeConfig;

    /**
     * Description message.
     * @var DirectoryList $directoryList
     */

    protected $pubDirectory;

    /**
     * Description message.
     * @var File $file
     */

    protected $file;

    /**
     * Description message.
     * @var FileDriver $fileDriver
     */

    protected $fileDriver;

    /**
     * Description message.
     * @var Context $context
     */
    protected $context;
    
    /**
     * Description message.
     *
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Config $resourceConfig
     * @param LoggerInterface $logger
     * @param ScopeConfigInterface $scopeConfig
     * @param DirectoryList $directoryList
     * @param File $file
     * @param FileDriver $fileDriver
     * @param CacheManager $cacheManager
     * @param CacheTypeList $cacheTypeList
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Config $resourceConfig,
        LoggerInterface $logger,
        ScopeConfigInterface $scopeConfig,
        DirectoryList $directoryList,
        File $file,
        FileDriver $fileDriver,
        CacheManager $cacheManager,
        CacheTypeList $cacheTypeList
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->_resourceConfig = $resourceConfig;
        $this->logger = $logger;
        $this->context = $context;
        $this->scopeConfig = $scopeConfig;
        $this->pubDirectory = $directoryList->getPath(DirectoryList::PUB);
        $this->file = $file;
        $this->fileDriver = $fileDriver;
        $this->cacheManager = $cacheManager;
        $this->cacheTypeList = $cacheTypeList;
    }

    /**
     * Description message.
     *
     * @return ScopeConfigInterface $scopeConfig
     */
    private function getNitroxOrgToken()
    {
        return $this->scopeConfig->getValue('admin/nitrox/nitrox_org_token', ScopeInterface::SCOPE_STORE);
    }

    /**
     * Description message.
     *
     * @return ($this->getRequest()->isPost() is true ? void : PageFactory $resultPageFactory)
     */
    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Nitrox_EventBridge::menu');
        $resultPage->getConfig()->getTitle()->prepend(__('Nitrox'));
        if ($this->getRequest()->isPost()) {
            $params = $this->getRequest()->getParams();
            
            $nitroxOrgToken = $params['nitrox_org_token'];

            $this->_resourceConfig->saveConfig('admin/nitrox/nitrox_org_token', $nitroxOrgToken, 'default', 0);
            
            $cacheType = \Magento\Framework\App\Cache\Type\Config::TYPE_IDENTIFIER;
            $this->cacheTypeList->cleanType($cacheType);
            $this->messageManager->addSuccess(__('Nitrox configuration has been saved.'));
            $this->_redirect('*/*/index');

            return;
        }
    
        return $resultPage;
    }

    /**
     * Description message.
     *
     * @return \Magento\Framework\AuthorizationInterface $this->_authorization
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Nitrox_EventBridge::menu');
    }
}
