<?php

namespace Nitrox\EventBridge\Block\PixelScript;

use Magento\Framework\View\Element\Template;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Config\Model\ResourceModel\Config;
use Magento\Store\Model\ScopeInterface;

class Index extends Template
{
    /**
     * Description message.
     *
     * @var ScopeConfigInterface $scopeConfig
     */

    protected $scopeConfig;

    /**
     * Description message.
     *
     * @var Config $resourceConfig
     */

    protected $_resourceConfig;

    /**
     * Description message.
     *
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     * @param Config $resourceConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        Config $resourceConfig
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->_resourceConfig = $resourceConfig;
        parent::__construct($context);
    }

    /**
     * Description message.
     *
     * @return string
     */
    private function getOrgId()
    {
        return $this->scopeConfig->getValue('admin/nitrox/nitrox_org_token', ScopeInterface::SCOPE_STORE);
    }

    /**
     * Description message.
     *
     * @return (org_id && api_token is not empty) ? string : void
     */
    public function _toHtml()
    {
        $org_id = $this->getOrgId();

        // if ( ( ( !isset($org_id) && empty($org_id) ) || ( !isset($api_token) && empty($api_token) ) ) ) {
        if (empty($org_id)) {
            return;
        }

        $script_code = <<<EOL
        \n<!-- Added by Nitrox Magento Extension -->\n
        <script data-cfasync="false" type="text/javascript">
        (function(n,i,t,r,o) {
        var a,m;n['NitroObject']=o;n[o]=n[o]||function(){
        (n[o].q=n[o].q||[]).push(arguments)},n[o].l=1*new Date();n[o].h=r;a=i.createElement(t),
        m=i.getElementsByTagName(t)[0];a.async=1;a.src=r;m.parentNode.insertBefore(a,m)
        })(window,document,'script','https://x.nitrocommerce.ai/nitro.js','nitro');
        nitro('configure', '$org_id', 'MAGENTO');
        </script>\n<!-- End Nitrox Integration -->\n\n
        EOL;

        return $script_code;
    }
}
